/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Date;
import java.util.Set;
import org.sonar.api.utils.TempFolder;
import org.sonarqube.ws.QualityProfiles;
import org.sonarsource.sonarlint.core.container.connected.CloseableWsResponse;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StorageManager;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.FileUtils;
import org.sonarsource.sonarlint.core.util.StringUtils;
import org.sonarsource.sonarlint.core.util.VersionUtils;

public class ModuleConfigUpdateExecutor {
    private final StorageManager storageManager;
    private final SonarLintWsClient wsClient;
    private final TempFolder tempFolder;

    public ModuleConfigUpdateExecutor(StorageManager storageManager, SonarLintWsClient wsClient, TempFolder tempFolder) {
        this.storageManager = storageManager;
        this.wsClient = wsClient;
        this.tempFolder = tempFolder;
    }

    public void update(String moduleKey) {
        Sonarlint.GlobalProperties globalProps = this.storageManager.readGlobalPropertiesFromStorage();
        Set<String> qProfileKeys = this.storageManager.readRulesFromStorage().getQprofilesByKey().keySet();
        Sonarlint.ModuleConfiguration.Builder builder = Sonarlint.ModuleConfiguration.newBuilder();
        this.fetchProjectQualityProfiles(moduleKey, qProfileKeys, builder);
        this.fetchProjectProperties(moduleKey, globalProps, builder);
        Path temp = this.tempFolder.newDir().toPath();
        ProtobufUtil.writeToFile(builder.build(), temp.resolve("configuration.pb"));
        Sonarlint.UpdateStatus updateStatus = Sonarlint.UpdateStatus.newBuilder().setClientUserAgent(this.wsClient.getUserAgent()).setSonarlintCoreVersion(VersionUtils.getLibraryVersion()).setUpdateTimestamp(new Date().getTime()).build();
        ProtobufUtil.writeToFile(updateStatus, temp.resolve("update_status.pb"));
        Path dest = this.storageManager.getModuleStorageRoot(moduleKey);
        FileUtils.deleteDirectory(dest);
        FileUtils.forceMkDirs(dest.getParent());
        FileUtils.moveDir(temp, dest);
    }

    private void fetchProjectQualityProfiles(String moduleKey, Set<String> qProfileKeys, Sonarlint.ModuleConfiguration.Builder builder) {
        try (InputStream contentStream = this.wsClient.get("/api/qualityprofiles/search.protobuf?projectKey=" + StringUtils.urlEncode(moduleKey)).contentStream();){
            QualityProfiles.SearchWsResponse qpResponse = QualityProfiles.SearchWsResponse.parseFrom(contentStream);
            for (QualityProfiles.SearchWsResponse.QualityProfile qp : qpResponse.getProfilesList()) {
                String qpKey = qp.getKey();
                if (!qProfileKeys.contains(qpKey)) {
                    throw new IllegalStateException("Module " + moduleKey + " is associated to quality profile " + qpKey + " that is not in storage. Server storage is probably outdated. Please update server.");
                }
                builder.getMutableQprofilePerLanguage().put(qp.getLanguage(), qp.getKey());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load module quality profiles", e);
        }
    }

    private void fetchProjectProperties(String moduleKey, Sonarlint.GlobalProperties globalProps, Sonarlint.ModuleConfiguration.Builder projectConfigurationBuilder) {
        CloseableWsResponse response = this.wsClient.get("api/properties?format=json&resource=" + StringUtils.urlEncode(moduleKey));
        String responseStr = response.content();
        try (JsonReader reader = new JsonReader(new StringReader(responseStr));){
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                ModuleConfigUpdateExecutor.parseProperty(globalProps, projectConfigurationBuilder, reader);
                reader.endObject();
            }
            reader.endArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse project properties from: " + response.content(), e);
        }
    }

    private static void parseProperty(Sonarlint.GlobalProperties globalProps, Sonarlint.ModuleConfiguration.Builder projectConfigurationBuilder, JsonReader reader) throws IOException {
        String key = null;
        String value = null;
        while (reader.hasNext()) {
            String propName = reader.nextName();
            if ("key".equals(propName)) {
                key = reader.nextString();
                continue;
            }
            if ("value".equals(propName)) {
                value = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        if (!globalProps.getProperties().containsKey(key) || !globalProps.getProperties().get(key).equals(value)) {
            projectConfigurationBuilder.getMutableProperties().put(key, value);
        }
    }
}

